#ifndef __CRegistryInfo__
#define __CRegistryInfo__

#include "../Basics/CString.hpp"
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CRegistryInfo CRegistryInfo.hpp
		 * @brief Store the name and value of a single key from the registry
		 *
		 * @date 18/02/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.1.0 Made child of CCountedObject, removed virtuals
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CRegistryInfo.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CRegistryInfo : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param name The name of the key
			 * @param value The value of the key
			 */
			CRegistryInfo(const CString &name, const CString &value);

			/**
			 * Destruction
			 */
			virtual ~CRegistryInfo();

//	===========================================================================

			/**
			 * Set the name
			 * @param name The name of the key
			 */
			void setName(const CString &name);

			/**
			 * Set the value of the key
			 * @param value The value of the key
			 */
			void setValue(const CString &value);

//	===========================================================================

			/**
			 * Get the name
			 * @retval const CString& The name of the key
			 */
			const CString &getName() const;

			/**
			 * Get hte value
			 * @retval const CString& The key value
			 */
			const CString &getValue() const;

//	===========================================================================

		protected:

//	===========================================================================

			CString m_keyName;				/**< The name of the object */
			CString m_keyValue;				/**< The value of the object */

		};
	}
}
#endif	// End of CRegistryInfo.hpp